local t = Def.ActorFrame {};
local playMode = GAMESTATE:GetPlayMode()

local sStage = ""
sStage = GAMESTATE:GetCurrentStage()

if playMode ~= 'PlayMode_Regular' and playMode ~= 'PlayMode_Rave' and playMode ~= 'PlayMode_Battle' then
  sStage = playMode;
end;

if not (GAMESTATE:IsCourseMode() or GAMESTATE:IsExtraStage() or GAMESTATE:IsExtraStage2()) then
        local tRemap = {
                Stage_Event             = 0,
                Stage_1st               = 1,
                Stage_2nd               = 2,
                Stage_3rd               = 3,
                Stage_4th               = 4,
                Stage_5th               = 5,
                Stage_6th               = 6,
                Stage_Final               = 7,
                Stage_Extra1               = 8,
                Stage_Extra2              = 9,
        };

        local nSongCount = tRemap[sStage] + (GAMESTATE:GetCurrentSong():GetStageCost()-1);

        if nSongCount >= PREFSMAN:GetPreference("SongsPerPlay") then
        sStage = "Stage_Final";
        else
                sStage = sStage;
        end;
end;

	t[#t+1] = Def.Quad {
			InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;diffuse,color("#FFFFFF");zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;);
			OnCommand=function(self)
				self:diffusealpha(1):linear(0.6):diffusealpha(0);
			end;		
	};
	
	if not GAMESTATE:IsCourseMode() then
		t[#t+1] = Def.Sprite {
			InitCommand=cmd(Center);
			BeginCommand=cmd(LoadFromCurrentSongBackground);
			OnCommand=function(self)
				self:scale_or_crop_background()
				self:diffusealpha(0.2):linear(0.6):diffusealpha(0);
			end;
		};
	end

	t[#t+1] = Def.ActorFrame {
	Def.ActorFrame {
		InitCommand=cmd(x,SCREEN_CENTER_X+150;y,SCREEN_CENTER_Y;rotationz,-16;zoom,0.8;);
		OnCommand=cmd(diffusealpha,1;smooth,0.5;diffusealpha,0;zoom,0.6;rotationz,-24;);
		LoadActor(THEME:GetPathG("_jacket", "shell")) .. {
			InitCommand=cmd(zoom,0.55);
		};
		Def.Sprite {
			name="SongJacket";
			OnCommand=cmd(playcommand,"Set");
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
			SetCommand=function(self)
					local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
							if target then
								if GAMESTATE:IsCourseMode() == false then
									if target:HasJacket() == true then
										self:Load(target:GetJacketPath())
										self:scaletoclipped(246,246)
									elseif target:HasBackground() == true then
										self:Load(target:GetBackgroundPath())
										self:scaletoclipped(246,246)
									elseif target:HasBanner() == true then
										self:Load(target:GetBannerPath())
										self:scaletoclipped(256,80)
									elseif target:HasBanner() == false then
										self:Load(THEME:GetPathG("Common fallback", "jacket"))
										self:scaletoclipped(246,246)
									end
								else
									if target:HasBanner() == true then
										self:Load(target:GetBannerPath())
										self:scaletoclipped(256,80)
									elseif target:HasBanner() == false then
										self:Load(THEME:GetPathG("Common fallback", "jacket"))
										self:scaletoclipped(246,246)
									end
								end;
							else
								self:Load(THEME:GetPathG("Common fallback", "jacket"))
							end
					end;
		};
	};
	};
	
	t[#t+1] = Def.ActorFrame {
		InitCommand=cmd(x,SCREEN_CENTER_X-220;y,SCREEN_CENTER_Y+76);
		OnCommand=function(self)
			self:diffusealpha(1):linear(0.6):diffusealpha(0);
		end;		
			LoadFont("Common Normal") .. {
			  Text=GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() or GAMESTATE:GetCurrentSong():GetDisplayFullTitle();
			  InitCommand=cmd(horizalign,left;diffuse,color("#000000");strokecolor,color("#FFFFFF");maxwidth,480);
			  OnCommand=cmd(zoom,1);
			};
			LoadFont("Common Normal") .. {
			  Text=GAMESTATE:IsCourseMode() and ToEnumShortString( GAMESTATE:GetCurrentCourse():GetCourseType() ) or GAMESTATE:GetCurrentSong():GetDisplayArtist();
			  InitCommand=cmd(horizalign,left;diffuse,color("#000000");strokecolor,color("#FFFFFF");maxwidth,480);
			  OnCommand=cmd(zoom,0.8;addy,26;);
			};
			LoadActor( THEME:GetPathG("ScreenStageInformation", "Stage " .. ToEnumShortString(sStage) ) ) .. {
			  InitCommand=cmd(horizalign,right;addx,250);
			  OnCommand=cmd(zoom,0.6;addy,-45;);
			};	
		};

return t;